#################################################################  
# R code: Example 9.8
# File: Forecasting-USunemplmnt.r
# 
# Direct Forecasting with US unemployment time series
# using R code written by Nikolay Robinzonov
#
# Reference:
# Robinzonov, N., Tutz, G., and Hothorn, T. (2012).
#	Boosting techniques for nonlinear time series models.
#	Advances in Statistical Analysis, 96(1), 99--122.
#	DOI: 10.1007/s10182-011-0163-4.
#################################################################
rm(list = ls(all = T)) 
library(GAMBoost)
library(mboost)
library(vars)
library(mda)
library(zoo)
source("c:/ ... /boost_nlar/analysis/functions/helpers-general.R") # 
source("c:/ ... /boost_nlar/analysis/functions/helpers-forecasting.R") # 
source("c:/ ... /boost_nlar/analysis/functions/f-VAR.R")       

USUNEMP_logist_n250 <- read.table("C:/ ... /USUNEMP_logist_n250.dat", quote="\"")
USun <- ts(USUNEMP_logist_n250,start=c(1948,1),freq=4)
USun
save(USun,file="c:/ ... /USun.RData")

print(load("c:/ ... /USun.RData"))


#######  defaults #############################
setup <- list(ychar = "USun",
              xchar = c("USun"),   
              iniend = c(2002,1),
              maxLag = 12,
              hors = c(1,4, 8, 12))

#lsstp <- generate.setup(setup, xchars)
lsstp <- list(setup)


#######  parsets  #############################
parset.glmboost <- list(method = "glmboost",
                        mstop = 500,
                        dummy = FALSE)

parset.gamboost <- list(method = "gamboost",
                        df = 3.5,
                        knots = 20,
                        mstop = 500,
                        dummy = FALSE)

######   mda  ###############
parset.bruto <- list(method = "bruto",
                     cost = "log")

parset.mars  <- list(method = "mars",
                     penalty = "log")


parset <- parset.glmboost

###### Forecasting ############################
dname <- make.names(format(Sys.time(), "%b %d %a %H %M %S"))
dirname <- paste("c:/ ... /boost_nlar/res/fcstres_IP/",dname,"/",sep="")
dir.create(dirname)
print(dirname)

#######  mboost   ############
lsglmUSun <- lapply(lsstp, function(z) dir.paradigm(z, parset.glmboost))

## save(lsglmUSun, file = paste(dirname, "lsglmUSun.rda", sep=""))

lsgamUSun <- lapply(lsstp, function(z) dir.paradigm(z, parset.gamboost))
## save(lsgamUSun, file = paste(dirname,"lsgam.rda",sep=""))

### mda
lsbrutoUSun <- lapply(lsstp, function(z) dir.paradigm(z, parset.bruto))
## save(lsbrutoUSun, file = paste(dirname,"lsbrutoIP.rda", sep=""))

lsmarsUSun <- lapply(lsstp, function(z) dir.paradigm(z, parset.mars))
##save(lsmarsUSun, file = paste(dirname,"lsmarsIP.rda", sep=""))

